import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { couponCalculation } from "../../../../screens/ShoppingCart/OrderSummary/couponCalculation";
import { mutationResponse } from "../../util/processResponse.js";

const checkCouponUrl = `${BASE_API_URL_STG}/user/check-coupon`;

const initialState = {
    data: {
        couponArray: [],
        totalCouponDiscount: 0,
    },
    isLoading: false,
    error: null,
    successText: null,
};

export const applyCoupon = createAsyncThunk(
    "cart/applyCoupon",
    async (params) => {
        const { access_token, formData } = params;
        try {
            const response = await mutationResponse(
                checkCouponUrl,
                "POST",
                formData,
                access_token
            );
            return response;
        } catch (err) {}
    }
);

const applyCouponSlice = createSlice({
    name: "applyCoupon",
    initialState,
    reducers: {
        resetCoupon: (state) => {
            state.data = {
                couponArray: [],
                totalCouponDiscount: 0,
            };
            state.isLoading = false;
            state.error = null;
            state.successText = null;
        },
        handleErrMsg: (state, {payload}) => {
            state.error = payload
        },
        handleSuccessMsg: (state, {payload}) => {
            state.successText = payload
        },
        deleteCoupon: (state, { payload }) => {
            if (state.data?.couponArray?.length > 0) {
                state.successText = null;
                const updatedCoupon = state.data?.couponArray?.filter(
                    (item) => item.id !== payload
                );
                const totalCouponDiscount = updatedCoupon.reduce(
                    (acc, curr) => acc + Number(curr?.discount_amount),
                    0
                );
                state.data.couponArray = updatedCoupon;
                state.data.totalCouponDiscount = totalCouponDiscount;
            }
        },
    },
    extraReducers: (builder) => {
        builder.addCase(applyCoupon.pending, (state) => {
            state.isLoading = true;
        });
        builder.addCase(applyCoupon.fulfilled, (state, { payload }) => {
            state.isLoading = false;
            const { status, records } = payload;
            if (status?.message === "OK") {
                const couponOption = couponCalculation(records);
                state.data = couponOption;
                state.successText =
                    "Congrats you are eligible for this coupon in this order.";
                state.error = null
            } else {
                state.error = status?.message;
                state.successText = null;
            }
        });
        builder.addCase(applyCoupon.rejected, (state) => {
            state.isLoading = false;
        });
    },
});

export const { resetCoupon, deleteCoupon, handleErrMsg, handleSuccessMsg } = applyCouponSlice.actions;
export default applyCouponSlice.reducer;
